/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.security;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.InfoPanel;
import com.ibm.hsc.websm.security.ObjMgrSec;
import com.ibm.websm.bridge.WRemoteSystem;
import com.ibm.websm.console.plugin.WPlugin;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EPiiHook;
import com.ibm.websm.etc.EUiUtil;
import com.ibm.websm.help.WGHelpDialog;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.widget.WGLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ObjMgrSecDialog
extends WGHelpDialog
implements FocusListener {
    private MOClass _moclass;
    private WPlugin _plugin;
    private JFrame _parent;
    private WRemoteSystem _rs;
    private ButtonGroup _buttons;
    private JRadioButton _plainSocketButton = null;
    private JRadioButton _sslButton = null;
    private WGLabel _message = null;
    static /* synthetic */ Class class$com$ibm$hsc$websm$security$ObjMgrSec;

    public ObjMgrSecDialog(MOClass mOClass, WPlugin wPlugin) {
        super(ObjMgrSec.getString("DIALOG_TITLE"), new WGHelpDialog.WhichButtons(true, false, false, true, false));
        this._moclass = mOClass;
        this._plugin = wPlugin;
        this._createDialogContents();
        this.addFocusListener(this);
    }

    public static String getClassName() {
        return "ObjMgrSecDialog";
    }

    private void _createDialogContents() {
        if (IDebug.enabled) {
            IDebug.println((String)(ObjMgrSecDialog.getClassName() + ": in _createDialogContents()"));
        }
        this._message = new WGLabel(ObjMgrSec.getString("DIALOG_LABEL_MESSAGE"));
        this._plainSocketButton = new JRadioButton(ObjMgrSec.getString("PLAIN_SOCKET"));
        this._sslButton = new JRadioButton(ObjMgrSec.getString("SSL"));
        this._buttons = new ButtonGroup();
        this._buttons.add(this._plainSocketButton);
        this._buttons.add(this._sslButton);
        int n = this.getSecurityMode();
        switch (n) {
            case 0: {
                this._buttons.setSelected(this._plainSocketButton.getModel(), true);
                break;
            }
            case 1: {
                this._buttons.setSelected(this._sslButton.getModel(), true);
                break;
            }
        }
        RadioListener radioListener = new RadioListener();
        this._plainSocketButton.addActionListener(radioListener);
        this._sslButton.addActionListener(radioListener);
        JPanel jPanel = this.getDialogContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        int n5 = 12;
        int n6 = 12;
        this._constrain(jPanel, (Component)this._message, n2, n3, 0, 1, 2, 17, 1.0, 1.0, n5, n5, 0, n5);
        this._constrain(jPanel, this._plainSocketButton, n2, ++n3, n4, 1, 2, 17, 1.0, 1.0, n6, n5 + n5, 0, n5);
        this._constrain(jPanel, this._sslButton, n2, ++n3, n4, 1, 2, 17, 1.0, 1.0, n6, n5 + n5, 0, n5);
        this.setSize(350, 200);
        this.enableForPii(new EPiiHook((class$com$ibm$hsc$websm$security$ObjMgrSec == null ? (class$com$ibm$hsc$websm$security$ObjMgrSec = ObjMgrSecDialog.class$("com.ibm.hsc.websm.security.ObjMgrSec")) : class$com$ibm$hsc$websm$security$ObjMgrSec).getName(), "INST_PRIV_KEY_RING"));
        EUiUtil.autoMnemonic((Container)((Object)this));
    }

    private int getSecurityMode() {
        int n = 0;
        Integer n2 = null;
        try {
            n2 = (Integer)this._moclass.invokeStaticMethod("getCimSocketMode");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (n2 != null && (n = n2.intValue()) != 0 && n != 1) {
            n = 0;
        }
        return n;
    }

    public void displayValues() {
        this.setVisible(true);
        this._updateOkButton();
    }

    private void _updateOkButton() {
        if (IDebug.enabled) {
            IDebug.println((String)(ObjMgrSecDialog.getClassName() + ": in _updateOkButton()"));
        }
        if (this._plainSocketButton.isSelected() || this._sslButton.isSelected()) {
            this._okButton.setEnabled(true);
        } else {
            this._okButton.setEnabled(false);
        }
        this.setDefaultButton(4);
    }

    public boolean checkValues() {
        Boolean bl = new Boolean(false);
        Boolean bl2 = new Boolean(false);
        try {
            bl = (Boolean)this._moclass.invokeStaticMethod("serverKeyInstalled");
            bl2 = (Boolean)this._moclass.invokeStaticMethod("caPubKeyInstalled");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ButtonModel buttonModel = this._buttons.getSelection();
        if (buttonModel.equals(this._sslButton.getModel())) {
            if (!bl.booleanValue()) {
                this.displayError(ObjMgrSec.getString("PRIVATE_KEY_MISSING"));
                return false;
            }
            if (!bl2.booleanValue()) {
                this.displayError(ObjMgrSec.getString("CA_PUBKEY_MISSING"));
                return false;
            }
            this.displayInfo(ObjMgrSec.getString("REBOOT_INFO_SSL"));
        } else if (buttonModel.equals(this._plainSocketButton.getModel())) {
            this.displayInfo(ObjMgrSec.getString("REBOOT_INFO_PLAIN"));
        } else {
            return false;
        }
        return true;
    }

    private void displayError(String string) {
        String string2 = HSCResourceBundleUtil.getMessage("UserBundle", "ERROR");
        new ErrorPanel(string, string2).show();
    }

    private void displayInfo(String string) {
        String string2 = HSCResourceBundleUtil.getMessage("ServiceAgentText", "INFO_TITLE");
        new InfoPanel(string, string2, "").show();
    }

    public boolean saveValues() {
        if (IDebug.enabled) {
            IDebug.println((String)(ObjMgrSecDialog.getClassName() + ": in saveValues()"));
        }
        ButtonModel buttonModel = this._buttons.getSelection();
        Object[] objectArray = new Object[1];
        if (buttonModel.equals(this._plainSocketButton.getModel())) {
            objectArray[0] = new Integer(0);
        } else if (buttonModel.equals(this._sslButton.getModel())) {
            objectArray[0] = new Integer(1);
        }
        try {
            this._moclass.invokeStaticMethod("setCimSocketMode", objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        ButtonModel buttonModel = this._buttons.getSelection();
        if (buttonModel.equals(this._plainSocketButton.getModel())) {
            this._plainSocketButton.requestFocus();
        } else if (buttonModel.equals(this._sslButton.getModel())) {
            this._sslButton.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void _constrain(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (n7 + n9 + n8 + n10 > 0) {
            gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        }
        ((GridBagLayout)container.getLayout()).setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RadioListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ObjMgrSecDialog.this._updateOkButton();
        }
    }
}

